/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	Header File for Feature Convenience Functions.

#pragma once

HRESULT __declspec(dllexport) UpdateDesign() ;

HRESULT __declspec(dllexport) ConstantRadiusBlending(ISet *pedge,VARIANT_BOOL bChamfer,VARIANT_BOOL bFlipped,VARIANT_BOOL bPropagate,VARIANT_BOOL bSmoothVariation,VARIANT_BOOL bGroupEdges,double radius,CString blendName,IBlend **pBlend);

HRESULT __declspec(dllexport) VariableRadiusBlending(ISet *pedge,VARIANT_BOOL bChamfer,VARIANT_BOOL bFlipped,VARIANT_BOOL bPropagate,VARIANT_BOOL bSmoothVariation,VARIANT_BOOL bGroupEdges,double *variableRadius,double *variableParams,int noOfVariableRadius,CString blendName,IBlend **pBlend) ;

HRESULT __declspec(dllexport) CreateExtrusion(ISketch *pSketch,double distanceAbove,int distanceBelow,double taperAngle,int side,long materialStatus,CString extrusionName,IExtrusion **pExtrusion) ;

HRESULT __declspec(dllexport) CreateRevolution(ISketch *profileSketch, IGeometric *axisGeometric, double revolutionAngle, long revolutionDirection,long side,long materialStatus, CString revolutionName, IRevolution **pRevolution);

HRESULT __declspec(dllexport) CreateHollow(ISet *pface,double offsetDistance,CString hollowName,IHollow **phollow) ;

HRESULT __declspec(dllexport) CreateSweep(ISketch *profileSketch,ISketch *pathSketch,long materialStatus,CString sweepName,ISweep **psweep) ;

HRESULT __declspec(dllexport) UseComponent(IDesignInstance *pComponent,long materialStatus,VARIANT_BOOL bHideComponent,CString featureName,ITool **pucomponent);

HRESULT __declspec(dllexport) UncondemnAll() ;

HRESULT __declspec(dllexport) CreateHole(ISketch *psk,ISet *pfaces,int below,long htype,long extent,double holediam,double holedpth,double tapratio,double countdiam,double countdpth,double countang,double drillang,CString holeName,IHole **pHole) ;

HRESULT __declspec(dllexport) CreateProjection(ISketch *pinputSketch,ISet *pfaces,long direction,long extent,long profileSide,double taperAngle ,long materialStatus, CString projectionName,IProjection **pprojection) ;
